/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.config;

import com.flemmli97.improvedmobs.ImprovedMobs;
import com.flemmli97.improvedmobs.config.BreakableBlocks;
import com.flemmli97.improvedmobs.config.ConfigSpecs;
import com.flemmli97.improvedmobs.config.DifficultyConfig;
import com.flemmli97.improvedmobs.config.EnchantCalcConf;
import com.flemmli97.improvedmobs.config.EntityItemConfig;
import com.flemmli97.improvedmobs.config.EntityModifyFlagConfig;
import com.flemmli97.improvedmobs.config.MobClassMapConfig;
import com.flemmli97.tenshilib.api.config.ItemWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.ModList;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class Config {

    public static enum DifficultyBarLocation {
        TOPRIGHT,
        TOPLEFT,
        BOTTOMRIGHT,
        BOTTOMLEFT;

    }

    public static enum DifficultyType {
        GLOBAL,
        PLAYERMAX,
        PLAYERMEAN;

    }

    public static class WeightedItem
    extends WeightedRandom.Item {
        private final ItemWrapper item;

        public WeightedItem(ItemWrapper item, int weight) {
            super(weight);
            this.item = item;
        }

        public ItemWrapper getItem() {
            return this.item;
        }
    }

    public static class CommonConfig {
        public static boolean enableDifficultyScaling;
        public static int difficultyDelay;
        public static DifficultyConfig increaseHandler;
        public static boolean ignorePlayers;
        public static List<String> mobListLight;
        public static boolean mobListLightBlackList;
        public static int light;
        public static boolean shouldPunishTimeSkip;
        public static boolean friendlyFire;
        public static List<String> petArmorBlackList;
        public static boolean petWhiteList;
        public static boolean doIMDifficulty;
        public static DifficultyType difficultyType;
        public static EntityModifyFlagConfig entityBlacklist;
        public static List<String> flagBlacklist;
        public static boolean mobAttributeWhitelist;
        public static boolean armorMobWhitelist;
        public static boolean heldMobWhitelist;
        public static boolean mobListBreakWhitelist;
        public static boolean mobListUseWhitelist;
        public static boolean mobListLadderWhitelist;
        public static boolean mobListStealWhitelist;
        public static boolean mobListBoatWhitelist;
        public static boolean mobListFlyWhitelist;
        public static boolean targetVillagerWhitelist;
        public static boolean neutralAggroWhitelist;
        public static boolean debugPath;
        public static boolean useScalingHealthMod;
        public static boolean legacyScalingHealth;
        public static BreakableBlocks breakableBlocks;
        public static boolean breakingAsBlacklist;
        public static boolean useBlockBreakSound;
        public static float breakerChance;
        public static int breakerInitCooldown;
        public static int breakerCooldown;
        public static float stealerChance;
        public static boolean breakTileEntities;
        public static List<WeightedItem> breakingItem;
        public static float neutralAggressiv;
        public static MobClassMapConfig autoTargets;
        public static int repairTick;
        public static float difficultyBreak;
        public static float difficultySteal;
        public static float guardianAIChance;
        public static float flyAIChance;
        public static List<String> equipmentModBlacklist;
        public static boolean equipmentModWhitelist;
        public static List<String> itemuseBlacklist;
        public static EntityItemConfig entityItemConfig;
        public static boolean itemuseWhitelist;
        public static float baseEquipChance;
        public static float baseEquipChanceAdd;
        public static float diffEquipAdd;
        public static float baseWeaponChance;
        public static float diffWeaponChance;
        public static float baseEnchantChance;
        public static float diffEnchantAdd;
        public static EnchantCalcConf enchantCalc;
        public static float baseItemChance;
        public static float diffItemChanceAdd;
        public static boolean shouldDropEquip;
        public static double healthIncrease;
        public static double healthMax;
        public static double roundHP;
        public static double damageIncrease;
        public static double damageMax;
        public static double speedIncrease;
        public static double speedMax;
        public static double knockbackIncrease;
        public static double knockbackMax;
        public static float magicResIncrease;
        public static float magicResMax;
        public static float projectileIncrease;
        public static float projectileMax;

        public static void load() {
            enableDifficultyScaling = (Boolean)ConfigSpecs.commonConf.enableDifficultyScaling.get();
            difficultyDelay = (Integer)ConfigSpecs.commonConf.difficultyDelay.get();
            ignorePlayers = (Boolean)ConfigSpecs.commonConf.ignorePlayers.get();
            mobListLight = (List)ConfigSpecs.commonConf.mobListLight.get();
            mobListLightBlackList = (Boolean)ConfigSpecs.commonConf.mobListLightBlackList.get();
            light = (Integer)ConfigSpecs.commonConf.light.get();
            shouldPunishTimeSkip = (Boolean)ConfigSpecs.commonConf.shouldPunishTimeSkip.get();
            friendlyFire = (Boolean)ConfigSpecs.commonConf.friendlyFire.get();
            petArmorBlackList = (List)ConfigSpecs.commonConf.petArmorBlackList.get();
            petWhiteList = (Boolean)ConfigSpecs.commonConf.petWhiteList.get();
            doIMDifficulty = (Boolean)ConfigSpecs.commonConf.doIMDifficulty.get();
            increaseHandler.readFromString((List)ConfigSpecs.commonConf.increaseHandler.get());
            difficultyType = (DifficultyType)((Object)ConfigSpecs.commonConf.difficultyType.get());
            List l = (List)ConfigSpecs.commonConf.entityBlacklist.get();
            if (l.size() != 1 || !((String)l.get(0)).equals("UNINIT")) {
                entityBlacklist.readFromString((List)ConfigSpecs.commonConf.entityBlacklist.get());
            }
            flagBlacklist = (List)ConfigSpecs.commonConf.flagBlacklist.get();
            mobAttributeWhitelist = (Boolean)ConfigSpecs.commonConf.mobAttributeWhitelist.get();
            armorMobWhitelist = (Boolean)ConfigSpecs.commonConf.armorMobWhitelist.get();
            heldMobWhitelist = (Boolean)ConfigSpecs.commonConf.heldMobWhitelist.get();
            mobListBreakWhitelist = (Boolean)ConfigSpecs.commonConf.mobListBreakWhitelist.get();
            mobListUseWhitelist = (Boolean)ConfigSpecs.commonConf.mobListUseWhitelist.get();
            mobListLadderWhitelist = (Boolean)ConfigSpecs.commonConf.mobListLadderWhitelist.get();
            mobListStealWhitelist = (Boolean)ConfigSpecs.commonConf.mobListStealWhitelist.get();
            mobListBoatWhitelist = (Boolean)ConfigSpecs.commonConf.mobListBoatWhitelist.get();
            mobListFlyWhitelist = (Boolean)ConfigSpecs.commonConf.mobListFlyWhitelist.get();
            targetVillagerWhitelist = (Boolean)ConfigSpecs.commonConf.targetVillagerWhitelist.get();
            neutralAggroWhitelist = (Boolean)ConfigSpecs.commonConf.neutralAggroWhitelist.get();
            debugPath = (Boolean)ConfigSpecs.commonConf.debugPath.get();
            useScalingHealthMod = (Boolean)ConfigSpecs.commonConf.useScalingHealthMod.get() != false && ModList.get().isLoaded("scalinghealth");
            legacyScalingHealth = ModList.get().getModContainerById("scalinghealth").map(container -> container.getModInfo().getVersion().compareTo((Object)new DefaultArtifactVersion("4.0.5+5")) <= 0).orElse(false);
            breakableBlocks.readFromString((List)ConfigSpecs.commonConf.breakableBlocks.get());
            breakingAsBlacklist = (Boolean)ConfigSpecs.commonConf.breakingAsBlacklist.get();
            useBlockBreakSound = (Boolean)ConfigSpecs.commonConf.useBlockBreakSound.get();
            breakerChance = ((Double)ConfigSpecs.commonConf.breakerChance.get()).floatValue();
            breakerInitCooldown = (Integer)ConfigSpecs.commonConf.breakerInitCooldown.get();
            breakerCooldown = (Integer)ConfigSpecs.commonConf.breakerCooldown.get();
            stealerChance = ((Double)ConfigSpecs.commonConf.stealerChance.get()).floatValue();
            breakTileEntities = (Boolean)ConfigSpecs.commonConf.breakTileEntities.get();
            breakingItem.clear();
            for (String s : (List)ConfigSpecs.commonConf.breakingItems.get()) {
                String[] sub = (s = s.replace(" ", "")).split(";");
                if (sub.length != 2) {
                    ImprovedMobs.logger.error("Faulty entry for breaking item {}", (Object)s);
                    continue;
                }
                try {
                    breakingItem.add(new WeightedItem(new ItemWrapper(sub[0]), Integer.parseInt(sub[1])));
                }
                catch (NumberFormatException e) {
                    ImprovedMobs.logger.error("Faulty entry for breaking item {}", (Object)s);
                }
            }
            neutralAggressiv = ((Double)ConfigSpecs.commonConf.neutralAggressiv.get()).floatValue();
            autoTargets.readFromString((List)ConfigSpecs.commonConf.autoTargets.get());
            repairTick = (Integer)ConfigSpecs.commonConf.repairTick.get();
            difficultyBreak = ((Double)ConfigSpecs.commonConf.difficultyBreak.get()).floatValue();
            difficultySteal = ((Double)ConfigSpecs.commonConf.difficultySteal.get()).floatValue();
            guardianAIChance = ((Double)ConfigSpecs.commonConf.guardianAIChance.get()).floatValue();
            flyAIChance = ((Double)ConfigSpecs.commonConf.flyAIChance.get()).floatValue();
            equipmentModBlacklist = (List)ConfigSpecs.commonConf.equipmentModBlacklist.get();
            equipmentModWhitelist = (Boolean)ConfigSpecs.commonConf.equipmentModWhitelist.get();
            itemuseBlacklist = (List)ConfigSpecs.commonConf.itemuseBlacklist.get();
            itemuseWhitelist = (Boolean)ConfigSpecs.commonConf.itemuseWhitelist.get();
            entityItemConfig.readFromString((List)ConfigSpecs.commonConf.entityItemConfig.get());
            baseEquipChance = ((Double)ConfigSpecs.commonConf.baseEquipChance.get()).floatValue();
            baseEquipChanceAdd = ((Double)ConfigSpecs.commonConf.baseEquipChanceAdd.get()).floatValue();
            diffEquipAdd = ((Double)ConfigSpecs.commonConf.diffEquipAdd.get()).floatValue();
            baseWeaponChance = ((Double)ConfigSpecs.commonConf.baseWeaponChance.get()).floatValue();
            diffWeaponChance = ((Double)ConfigSpecs.commonConf.diffWeaponChance.get()).floatValue();
            baseEnchantChance = ((Double)ConfigSpecs.commonConf.baseEnchantChance.get()).floatValue();
            diffEnchantAdd = ((Double)ConfigSpecs.commonConf.diffEnchantAdd.get()).floatValue();
            enchantCalc.readFromString((List)ConfigSpecs.commonConf.enchantCalc.get());
            baseItemChance = ((Double)ConfigSpecs.commonConf.baseItemChance.get()).floatValue();
            diffItemChanceAdd = ((Double)ConfigSpecs.commonConf.diffItemChanceAdd.get()).floatValue();
            shouldDropEquip = (Boolean)ConfigSpecs.commonConf.shouldDropEquip.get();
            healthIncrease = (Double)ConfigSpecs.commonConf.healthIncrease.get();
            healthMax = (Double)ConfigSpecs.commonConf.healthMax.get();
            roundHP = (Double)ConfigSpecs.commonConf.roundHP.get();
            damageIncrease = (Double)ConfigSpecs.commonConf.damageIncrease.get();
            damageMax = (Double)ConfigSpecs.commonConf.damageMax.get();
            speedIncrease = (Double)ConfigSpecs.commonConf.speedIncrease.get();
            speedMax = (Double)ConfigSpecs.commonConf.speedMax.get();
            knockbackIncrease = (Double)ConfigSpecs.commonConf.knockbackIncrease.get();
            knockbackMax = (Double)ConfigSpecs.commonConf.knockbackMax.get();
            magicResIncrease = ((Double)ConfigSpecs.commonConf.magicResIncrease.get()).floatValue();
            magicResMax = ((Double)ConfigSpecs.commonConf.magicResMax.get()).floatValue();
            projectileIncrease = ((Double)ConfigSpecs.commonConf.projectileIncrease.get()).floatValue();
            projectileMax = ((Double)ConfigSpecs.commonConf.projectileMax.get()).floatValue();
        }

        public static void serverInit(ServerWorld world) {
            List l = (List)ConfigSpecs.commonConf.entityBlacklist.get();
            if (l.size() == 1 && ((String)l.get(0)).equals("UNINITIALIZED")) {
                entityBlacklist.initDefault((World)world);
                ConfigSpecs.commonConf.entityBlacklist.set(entityBlacklist.writeToString());
            }
        }

        public static ItemStack getRandomBreakingItem(Random rand) {
            int total = WeightedRandom.func_76272_a(breakingItem);
            if (breakingItem.size() == 0 || total <= 0) {
                return ItemStack.field_190927_a;
            }
            ItemWrapper r = ((WeightedItem)WeightedRandom.func_76273_a((Random)rand, breakingItem, (int)total)).getItem();
            return r.getStack();
        }

        static {
            increaseHandler = new DifficultyConfig();
            difficultyType = DifficultyType.GLOBAL;
            entityBlacklist = new EntityModifyFlagConfig();
            useScalingHealthMod = true;
            breakableBlocks = new BreakableBlocks();
            breakingItem = new ArrayList<WeightedItem>();
            autoTargets = new MobClassMapConfig();
            repairTick = 200;
            entityItemConfig = new EntityItemConfig().add(new ResourceLocation("skeleton"), "BOW").add(new ResourceLocation("wither_skeleton"), "BOW").add(new ResourceLocation("stray"), "BOW").add(new ResourceLocation("illusioner"), "BOW").add(new ResourceLocation("drowned"), "TRIDENT").add(new ResourceLocation("piglin"), "CROSSBOW").add(new ResourceLocation("pillager"), "CROSSBOW").add(new ResourceLocation("snow_golem"), "minecraft:snowball");
            enchantCalc = new EnchantCalcConf();
        }
    }

    public static class ClientConfig {
        public static int guiX;
        public static int guiY;
        public static TextFormatting color;
        public static float scale;
        public static boolean showDifficulty;
        public static DifficultyBarLocation location;

        public static void load() {
            guiX = (Integer)ConfigSpecs.clientConf.guiX.get();
            guiY = (Integer)ConfigSpecs.clientConf.guiY.get();
            color = (TextFormatting)ConfigSpecs.clientConf.color.get();
            scale = ((Double)ConfigSpecs.clientConf.scale.get()).floatValue();
            showDifficulty = (Boolean)ConfigSpecs.clientConf.showDifficulty.get();
            location = (DifficultyBarLocation)((Object)ConfigSpecs.clientConf.location.get());
        }

        static {
            color = TextFormatting.DARK_PURPLE;
            scale = 1.0f;
            location = DifficultyBarLocation.TOPLEFT;
        }
    }
}

